clear all
close all
clc
tic 

%Parameters 
WE = 2.25; 
theta = 1;
p = 0.2;
a = 5;
tau1 = 1;
tau2 = 5; 
T = 0.5; %simulation time for each increment used to estimate the Lyapunov Exponent globally. 
xnot = -1:0.1:1;  %mesh, note that we used a finer xnot = -1:0.02:1, ynot = -1:0.02:1 in the manuscript, however this takes about ~4 hours to run.  
ynot = -1:0.1:1;
[mx,my] = meshgrid(xnot,ynot); 
r = WE*(mx + j*my); %eigenvalue of the weight matrix 
r = r(:);
store = zeros(length(r),1);

for q = 1:length(r) %iterate of the eigenvalues 
N = 3;
NN = N^2 + N; 
int = [1,0,0];
y = zeros(NN,1); 
y(1:N,1) = int;  
y(N+1:NN) = reshape(eye(N),[N^2,1]);

tic
tot = 500;
lypc = zeros(tot,N);
cum = zeros(N,1);
%% Numerically integrate, and continuously orthogonalize, see references in manuscript for a detailed description of the algorithm. 
for nt = 1:tot
[t,ys] = ode45(@(t,y) wc_lin(WE,theta,p,a,tau1,tau2,r(q),t,y),[0,T],y);
ys = ys(end,:); 
vec= reshape(ys(N+1:NN),[N,N]);

% gram schmidt orthogonalization 
u = 0*vec; 
u(:,1)=vec(:,1)/sqrt(vec(:,1)'*vec(:,1));
znorm(1,1) = sqrt(vec(:,1)'*vec(:,1));
for i = 2:N 
    u(:,i) = vec(:,i); 
    for j = 1:i-1 
        u(:,i) = u(:,i) - ((u(:,j)'*u(:,i))/(u(:,j)'*u(:,j)))*u(:,j);
    end
znorm(i,1) =  sqrt(u(:,i)'*u(:,i));
u(:,i) = u(:,i)/sqrt(u(:,i)'*u(:,i));
end
cum = cum + log(znorm);

lypc(nt,:) = (cum)/(T*nt);
y(1:N) = ys(1:N); 
y(N+1:NN) = reshape(u,[N^2,1]); %use to reinitilize in the next iterate 
end
store(q) = max(lypc(end,:));
%%
toc
end

%% plot
storemat = reshape(store,[length(xnot),length(ynot)]);
imagesc(xnot,ynot,(real(storemat)),[-0.06,0]), hold on 
[surf] = contourc(xnot,ynot,real(storemat),[0,0]);
theta = 0:0.01:2*pi;
colormap('hot')
plot(cos(theta),sin(theta),'m','LineWidth',2), hold on 
xlabel('Real(r)')
ylabel('Imag(r)')
